﻿'
' Adapter class to allow objects that access an AddressIF object to access
' a customer's bill-to address.
'
Public Class CustomerBillToAdapter
    Implements IAddress
    Private myCustomer As Customer

    Public Sub New(ByVal customer As Customer)
        myCustomer = customer
    End Sub

    '
    ' Get/Set the first line of the street address.
    '
    Public Property Address1() As String _
      Implements IAddress.Address1
        Get
            Return myCustomer.BillToAddress1
        End Get
        Set(ByVal value As String)
            myCustomer.BillToAddress1 = value
        End Set
    End Property

    '
    ' Get/Set the second line of the street address.
    '
    Public Property Address2() As String _
      Implements IAddress.Address2
        Get
            Return myCustomer.BillToAddress2
        End Get
        Set(ByVal value As String)
            myCustomer.BillToAddress2 = value
        End Set
    End Property

    '
    ' Get/Set the city.
    '
    Public Property City() As String _
      Implements IAddress.City
        Get
            Return myCustomer.BillToCity
        End Get
        Set(ByVal value As String)
            myCustomer.BillToCity = value
        End Set
    End Property

    '
    ' Get/Set the state.
    '
    Public Property State() As String _
      Implements IAddress.State
        Get
            Return myCustomer.BillToState
        End Get
        Set(ByVal value As String)
            myCustomer.BillToState = value
        End Set
    End Property

    '
    ' get/set the postal code
    '
    Public Property PostalCode() As String _
      Implements IAddress.PostalCode
        Get
            Return myCustomer.BillToPostalCode
        End Get
        Set(ByVal value As String)
            myCustomer.BillToPostalCode = value
        End Set
    End Property ' class CustomerBillToAdapter
End Class 'CustomerBillToAdapter
